<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    {{-- slot page --}}
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    {{-- menu active --}}
    <x-slot:menuActive>{{ $data['menuActive'] }}</x-slot:menuActive>
    <x-slot:menuOpen>{{ $data['menuOpen'] }}</x-slot:menuOpen>


    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
        <link rel="stylesheet"
            href="{{ asset('assets/') }}/admin/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>




    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-lg-8">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover myTable tab">
                                <thead>
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Nama Lengkap</th>
                                        <th>Username</th>
                                        <th>Level</th>
                                        <th>Tgl. Input</th>
                                        <th width="20%">Opsi</th>
                                    </tr>
                                </thead>
                                <tbody id="view">
                                    @forelse ($user as $u)
                                        <tr>
                                            <td class="text-center">{{ $no++ }}</td>
                                            <td>{{ $u->nm_user }}</td>
                                            <td>{{ $u->username }}</td>
                                            <td>{{ $u->level == '1' ? 'User Admin' : 'User Kasir' }}</td>
                                            <td>{{ tgl_indo($u->created_at) }}</td>
                                            <td class="text-center">
                                                <button class="btn btn-primary btn-sm mb-0 mt-0 edit"
                                                    data-id="{{ $u->id }}" data-toggle="modal"
                                                    data-target="#edit{{ $u->id }}">
                                                    <i class="fa fa-edit mr-2"></i> Edit
                                                </button>
                                                <button class="btn btn-danger btn-sm mb-0 mt-0 hapus"
                                                    data-id="{{ $u->id }}" data-nm="{{ $u->nm_user }}">
                                                    <i class="fa fa-trash mr-1"></i> Hapus
                                                </button>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center text-danger"> Data User belum
                                                Tersedia.
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title"><i class="fa fa-database text-primary"></i> Input {{ $data['page'] }}
                        </h3>
                    </div>
                    <form action="{{ route('user.store') }}" method="post">
                        <div class="card-body">
                            @csrf

                            <div class="form-group">
                                <label>Nama Lengkap</label>
                                <input type="text" name="nm_user" class="form-control" placeholder="Nama Lengkap"
                                    required value="{{ old('nm_user') }}">
                            </div>

                            <div class="form-group">
                                <label>Username</label>
                                <input type="text" name="username" class="form-control" placeholder="Username"
                                    required value="{{ old('username') }}">
                                @error('username')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Level User</label>
                                <select name="level" id="" class="form-control ">
                                    <option value="">Pilih Level</option>
                                    <option value="2" {{ old('level') == '2' ? 'selected' : '' }}>User Kasir
                                    </option>
                                    <option value="1" {{ old('level') == '1' ? 'selected' : '' }}>User Admin
                                    </option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Password</label>
                                <input type="password" name="password" class="form-control" placeholder="Password"
                                    required>

                                @error('password')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Konfirmasi Password</label>
                                <input type="password" name="password_confirmation" class="form-control"
                                    placeholder="Konfirmasi Password" required>

                                @error('password_confirmation')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>
                        </div>
                        <div class="card-footer">
                            <button type="reset" class="btn btn-default"><i class="fa fa-sync-alt"></i>
                                Reset</button>
                            <button class="btn btn-primary float-right"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
            </div>


        </div>


    </section>
    <!-- /.content -->


    @foreach ($user as $u)
        <div class="modal fade" id="edit{{ $u->id }}">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header bg-primary ">
                        <h4 class="modal-title">Edit Data</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="edit-user" method="POST">
                        <div class="modal-body">
                            @csrf
                            @method('put')
                            <input type="hidden" name="id" id="" value="{{ $u->id }}">
                            <input type="hidden" name="usrlama" id="" value="{{ $u->username }}">
                            <div class="form-group">
                                <label>Nama Lengkap</label>
                                <input type="text" name="nm_user" class="form-control" placeholder="Nama Lengkap"
                                    required value="{{ $u->nm_user }}">
                            </div>

                            <div class="form-group">
                                <label>Username</label>
                                <input type="text" name="username" class="form-control" placeholder="Username"
                                    required value="{{ $u->username }}">
                                @error('username')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label>Level User</label>
                                <select name="level" id="" class="form-control">
                                    <option value="">Pilih Level</option>
                                    <option value="2" {{ $u->level == '2' ? 'selected' : '' }}>User Kasir
                                    </option>
                                    <option value="1" {{ $u->level == '1' ? 'selected' : '' }}>User Admin
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Simpan</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach




    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables/jquery.dataTables.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
        <script src="{{ asset('assets/') }}/admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $(function() {
                $('.myTable').DataTable();
            });

            $('#view').on('click', '.hapus', function() {
                var id = $(this).attr('data-id');
                var nama = $(this).attr('data-nm');

                Swal.fire({
                    title: "Apa anda yakin?",
                    text: "User dengan Nama ( " + nama +
                        " ) & data yang berkaitan dengan User tersebut akan di hapus!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Ya, Hapus!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.location.href = "delete-user/" + id;
                    }
                });

            });
        </script>
    </x-slot:foot>

</x-admin.contents>
